%store the results for all simulations
res_all = zeros(10, 1);

%m denotes the number of agents and n denotes the number of items
m = 14; n = 2;

%valuation; V(i, j) denotes the value of the ith item to the jth agent
V = [[33, 26, 7, 29, 34, 25, 14, 8, 5, 12, 14, 17, 7, 5],
[26, 42, 24, 41, 33, 44, 62, 29, 18, 26, 16, 24, 14, 6]];

%we do ten simulations in total, with seeds from 1 to 10
for seed = 1 : 10
    rng(seed)
    %set random budget constraint
    budget = rand(m, 1) * 20;
    %all-one vectors of length n and m, respectively
    onesn = ones(n, 1);
    onesm = ones(m, 1);
    %ultimate result; initiate with 1
    res = 1;

    %iterate through all agents
    %ind = i indicates that the ith agent imposes a diversity constraint
    for ind = 1 : m

        %use convex optimization solver to compute the optimal allocation without diversity constraint
        cvx_begin
            %allocation; x(i, j) denotes the allocation of the ith item to the jth agent
            variable x(n, m);
            %maximize(sum(((x .* V)' * onesn).^0.1)); %Implements gamma-fairness for gamma = 0.1
            %maximize(sum(((x .* V)' * onesn).^0.5)); %implements gamma-fairness for gamma = 0.5
            %maximize(sum((x .* V)' * onesn)); %implements social welfare
            %maximize(sum(log((x .* V)' * onesn))); %implements nash welfare
            minimize(sum(pow_p((x .* V)' * onesn, -1))); %implements gamma-fairness for gamma = -1; approximate for MMF
            
            subject to
                0 <= x; %constraint: allocation is nonnegative
                x <= 1; %constraint: each individual allocation is no greater than 1
                x * onesm <= onesn; %constraint: the sum of allocation of one item is no greater than 1
                (x .* V)' * onesn <= budget %budget constraint
        cvx_end

        %use convex optimization solver to compute the optimal allocation with diversity constraint
        cvx_begin
            variable y(n, m);
            %maximize(sum(((y .* V)' * onesn).^0.1)); %Implements gamma-fairness for gamma = 0.1
            %maximize(sum(((y .* V)' * onesn).^0.5)); %implements gamma-fairness for gamma = 0.5
            %maximize(sum((y .* V)' * onesn)); %implements social welfare
            %maximize(sum(log((y .* V)' * onesn))); %implements nash welfare
            minimize(sum(pow_p((y .* V)' * onesn, -1))); %implements gamma-fairness for gamma = -1; approximate for MMF
            
            subject to
                0 <= y; %constraint: allocation is nonnegative
                y <= 1; %constraint: each individual allocation is no greater than 1
                y * onesm <= onesn; %constraint: the sum of allocation of one item is no greater than 1

                %diversity constraint: equalize the allocation of all
                %items for the ind^th agent; if the value of an item for this agent is 0, then
                %we will ignore this item for this agent (that is, do not 
                %require the allocation of this item to be equal to the others)
                V(1, ind) * V(2, ind) * y(1, ind) ==  V(1, ind) * V(2, ind) * y(2, ind);

                (y .* V)' * onesn <= budget %budget constraint
        cvx_end

        XV = x .* V; %ultimate valuation without diversity constraint
        YV = y .* V; %ultimate valuation with diversity constraint

        %compute the maximum q such that it satisfies q-NNE
        q = 1;
        for j = 1 : m
            orig = sum(XV( : ,j));
            after = sum(YV( : ,j));
            %we do not consider agents who get little valuation to begin with
            if j ~= ind && orig > 0.1 * budget(j, 1)
                q = min(q, after / orig);
            end 
        end

        res = min(res, q);
    end
    
    res_all(seed, 1) = res;
end